# Update Measurements
# Copyright 2004, 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 040907 - started design notes 
# 040914 - continued design notes; first draft of code
# 041218 - removed "weekly" from name of script; allow earliest and latest start to be the same
# 070405 - fixed missing import that was preventing the display of script errors

# These design notes are intended to explore the problem. They include more than will be 
#   implemented in the initial version.

# This needs to identify the following elements of the calculations:
#	- the measurement scripts
#	- the sequence of calculation
#	- the time periods
#	- the projects
#	- project/measurement records to update

# initial version will run for all projects that:
# no	- have a BaseStartDate or CalculatedStartDate
# no	- do not have an ActualEndDate
#	- that are referred to by any ProjectMeasurement record

# initial version will run for all weeks:
#	- from earliest CalculatedStarteDate or BaseStartDate or StartDate
#	- to week just ended

# Selection prior to running program  -- not supported
#	- selected project row(s)  - not supported, must be run from measurement report?
#	- selected project/measurement row(s)  - all periods for specified projects/measurements?
#	- selected time period column(s) - for specified 
#	- selected measurement cell(s)

import os
import sys

def RunScripts():

    if not ( Data.Database.has_key('Measurement')
        and Data.Database.has_key('Project')
        and Data.Database.has_key('ProjectMeasurement')
        ):
        pass   # should give error message

    tm = Data.Database['Measurement']
    tp = Data.Database['Project']
    tpm = Data.Database['ProjectMeasurement']

    scriptsRun = {}
    measure = {}
    project = {}
    records = []
    # build measurement list
    for k, v in tpm.iteritems():
        if v.get('zzStatus') == 'deleted': continue

        mid = v.get('MeasurementID')
        if not mid or not tm.has_key(mid): continue  # not tied to a meaurement
        
        pid = v.get('ProjectID')
        if not pid or not tp.has_key(pid): continue  # not tied to a project

        if not project.has_key(pid):
            project[pid] = 0

        # measure[mid] = 0
        s = tm[mid].get('Script')
        if s: scriptsRun[s] = 0

        records.append(k)

    if project == {}:
        if debug: print "no projects with measurements"
        return

    if debug: print "projects", project.keys()
    # find earliest date
    earlieststart = "9999-99-99"
    for k in project.keys():
        basestart, calcstart, planstart = map(tp[k].get, ['BaseStartDate', 'CalculatedStartDate', 'StartDate'])
        start = planstart or basestart or calcstart or Data.GetToday()
        # if debug: print "project", k, "dates", basestart, calcstart, planstart
        # if debug: print "start", start
        if Data.DateConv.has_key(start):
            if start < earlieststart: earlieststart = start
        else:
            if debug: print "invalid date", start

    des = Data.DateConv[earlieststart]
    earlieststart = Data.DateIndex[des - Data.DateInfo[des][2]]  # convert to week begin -- (date index) minus (day of week)

    # find most recent week
    d = Data.GetToday()
    di = Data.DateConv[d]
    latestdate = Data.DateIndex[di - Data.DateInfo[di][2]]  # convert to week begin -- (date index) minus (day of week)

    # if earliest date > latest date don't run measurements
    if earlieststart <= latestdate:
        periods = map( lambda x: Data.DateIndex[x], range( Data.DateConv[earlieststart], Data.DateConv[latestdate] + 1 + 35, 7 ) )
    else:
        if debug: print "invalid date range", earlieststart, latestdate
        return
    if debug: print "periods", periods

    projects = project.keys()
    # records is already set up

    if debug: print "scripts to run:", scriptsRun
    sd = Data.GetScriptDirectory()
    sd = os.path.join(sd, "zzMeasure")
    for s in scriptsRun:
        script = os.path.join(sd, s)
        try:
            execfile(script)
        except:
            error_info = sys.exc_info()
            sys.excepthook(*error_info)
            break

    Data.SetUndo("Update Weekly Measurements")

# do only if GanttPV version 0.2 or greater
RunScripts()
